// Saves options to chrome.storage
function save_options() {
  var d365url = document.getElementById('d365url').value;
  var d365cmp = document.getElementById('d365cmp').value;
  var d365inferUrl = document.getElementById('inferUrl').checked;
  chrome.storage.sync.set({
    defaultd365TableUrl: d365url,
    defaultd365TableCmp: d365cmp,
    inferUrl: d365inferUrl
  }, function () {
    // Update status to let user know options were saved.
    var status = document.getElementById('status');
    status.textContent = 'Options saved.';
    setTimeout(function () {
      status.textContent = '';
    }, 750);
  });
}

// Restores state using the preferences
// stored in chrome.storage.
function restore_options() {
  // Use default values
  chrome.storage.sync.get({
    defaultd365TableUrl: 'https://usnconeboxax1aos.cloud.onebox.dynamics.com',
    defaultd365TableCmp: 'usmf',
    inferUrl: true
  }, function (items) {
    document.getElementById('d365url').value = items.defaultd365TableUrl;
    document.getElementById('d365cmp').value = items.defaultd365TableCmp;
    document.getElementById('inferUrl').checked = items.inferUrl;
  });
}
function getChromeOmniboxSettings() {
  chrome.tabs.create({ url: 'chrome://flags/#omnibox-ui-max-autocomplete-matches' });
}

document.addEventListener('DOMContentLoaded', restore_options);
document.getElementById('save').addEventListener('click', save_options);
document.getElementById('sett').addEventListener('click', getChromeOmniboxSettings);