if (document.getElementById('search')) {
    document.getElementById('search').addEventListener('click', doSearch);

    document.onkeydown = function (e) {
        e = e || window.event;
        switch (e.which || e.keyCode) {
            case 13: doSearch();
                break;
        }
    };
}

if (document.getElementById("tableSearch")){
    document.getElementById("tableSearch").select();
}

window.onload = function (e) {

    if (getQueryVariable("form")) {
        let form = getQueryVariable("form");
        chrome.storage.sync.get({
            defaultd365TableUrl: 'https://usnconeboxax1aos.cloud.onebox.dynamics.com',
            defaultd365TableCmp: 'usmf',
            inferUrl: true
        }, function (items) {

            let results = document.getElementById('results');
            if(results){
                results.innerHTML = getFormResults(form, items.defaultd365TableUrl, items.defaultd365TableCmp);
            }

        });
    }
    else if (getQueryVariable("table")) {
        let table = getQueryVariable("table");
        chrome.storage.sync.get({
            defaultd365TableUrl: 'https://usnconeboxax1aos.cloud.onebox.dynamics.com',
            defaultd365TableCmp: 'usmf',
            inferUrl: true
        }, function (items) {

            let results = document.getElementById('results');
            if(results){
                results.innerHTML = getResults(table, items.defaultd365TableUrl, items.defaultd365TableCmp);
            }

        });
    }
}

//todo:two ways to parse args/also in content
//https://css-tricks.com/snippets/javascript/get-url-variables/
function getQueryVariable(variable) {
    var query = window.location.search.substring(1);
    var vars = query.split("&");
    for (var i = 0; i < vars.length; i++) {
        var pair = vars[i].split("=");
        if (pair[0] == variable) { return pair[1]; }
    }
    return (false);
}


function doSearch() {
    var mi = "/?mi=SysTableBrowser&TableName=";
    chrome.storage.sync.get({
        defaultd365TableUrl: 'https://usnconeboxax1aos.cloud.onebox.dynamics.com',
        defaultd365TableCmp: 'usmf',
        inferUrl: true
    }, function (items) {
        var tableSearch = document.getElementById("tableSearch").value;
        var results = document.getElementById('results');
        results.innerHTML = getResults(tableSearch, items.defaultd365TableUrl, items.defaultd365TableCmp);

    });



}

function getFormResults(input, baseUrl, cmp) {
    var list = axFormToAxTables.mappings.filter(item => {
        return item.formname == input
      });

    var mi = "/?mi=SysTableBrowser&TableName=";
    var cmpParm = "&cmp=";
    var limitedNav = "&limitednav=true&lng=en-us";

    if (list) {
        var resultsCount = document.getElementById('resultsCount');
        resultsCount.innerHTML = "<p>" + list.length + " result(s)</p>";
        list.sort(function (a, b) {
            var textA = a.table.toUpperCase();
            var textB = b.table.toUpperCase();
            return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
        });

    }

    var result = "<ul>";
    for (var i = 0; i < list.length; i++) {

        let curTable = axTables.find(item => {
            return item.table == list[i].table
         });

        result += "<li class=\"table\"><a class=\"resultList\" href=\"" + baseUrl + mi + list[i].table + cmpParm + cmp + limitedNav + "\">" + list[i].table;
        if (curTable && curTable.label) {
            result += " - " + curTable.label;
        }
        if (curTable && curTable.developerdocumentation) {
            result += "<ul><li class=\"docs\">" + curTable.developerdocumentation + "</li></ul>";
        }
        result += "</a></li>";

    }
    result += "</ul>";
    return result;
}

function getResults(input, baseUrl, cmp) {
    var list = axTables.filter(item => item.table.toLowerCase().includes(input.toLowerCase()));
    var mi = "/?mi=SysTableBrowser&TableName=";
    var cmpParm = "&cmp=";
    var limitedNav = "&limitednav=true&lng=en-us";

    if (list) {
        var resultsCount = document.getElementById('resultsCount');
        resultsCount.innerHTML = "<p>" + list.length + " result(s)</p>";
        list.sort(function (a, b) {
            var textA = a.table.toUpperCase();
            var textB = b.table.toUpperCase();
            return (textA < textB) ? -1 : (textA > textB) ? 1 : 0;
        });

    }

    var result = "<ul>";
    for (var i = 0; i < list.length; i++) {
        result += "<li class=\"table\"><a class=\"resultList\" href=\"" + baseUrl + mi + list[i].table + cmpParm + cmp + limitedNav + "\">" + list[i].table;
        if (list[i].label != "") {
            result += " - " + list[i].label;
        }
        if (list[i].developerdocumentation != "") {
            result += "<ul><li class=\"docs\">" + list[i].developerdocumentation + "</li></ul>";
        }
        result += "</a></li>";

    }
    result += "</ul>";
    return result;
}