/// <reference path="chrome.intellisense.js" />

//todo:two ways to parse args, also in index.js
//https://html-online.com/articles/get-url-parameters-javascript/
function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
        vars[key] = value;
    });
    return vars;
}
//https://html-online.com/articles/get-url-parameters-javascript/
function getUrlParam(parameter, defaultvalue) {
    var urlparameter = defaultvalue;
    if (window.location.href.indexOf(parameter) > -1) {
        urlparameter = getUrlVars()[parameter];
    }
    return urlparameter;
}


function getformName() {
    try {
        //todo: doesn't work on all form types, workspaces?
        //[0] seems to be navbar or something on non listpages?
        return document.querySelectorAll("form[data-dyn-form-name]")[1].getAttribute('data-dyn-form-name');
    } catch (error) {
        try {
            return document.querySelectorAll("form[data-dyn-form-name]")[0].getAttribute('data-dyn-form-name');
        } catch (error) {
            console.log("d3f2: " + error);
        }
        console.log("d3f2: " + error);
    }
}

function getCmp() {
    try {
        return getUrlParam("cmp", "dat");
    } catch (error) {
        return "dat";//todo:meh?
    }
}


// Listen for messages
chrome.runtime.onMessage.addListener(function (msg, sender, sendResponse) {
    // If the received message has the expected format...
    console.log("d3f2: contentjs on message " + msg);

    if (msg.text === 'report_back') {
        sendResponse("echo");
    }
});

document.addEventListener("DOMContentLoaded", function () {
    chrome.runtime.sendMessage(
        {
            farewell: window.location.origin,
            formName: getformName(),
            cmp: getCmp()
        },
        function (response) {
            console.log("oncompleted:" + response);
        }
    );
});

window.onload = function () {
    chrome.runtime.sendMessage(
        {
            farewell: window.location.origin,
            formName: getformName(),
            cmp: getCmp()
        },
        function (response) {
            console.log(response);
        }
    );
};

chrome.runtime.onMessage.addListener(
    function (request, sender, sendResponse) {

        if (request.action === "getCurrentUrl") {
            console.log("d3f2 inferUrl from content script:" + window.location.origin);
            var curFormName = getformName();
            var curCmp = getCmp();
            chrome.storage.sync.set({
                d3f2formname: curFormName,
                d3f2cmp: curCmp
            }, function () {
                // Update status to let user know options were saved.
                console.log('d3f2 formname saved: ' + curFormName);
                sendResponse({
                    farewell: window.location.origin,
                    formName: curFormName,
                    cmp: curCmp
                });

            });

            sendResponse({
                farewell: window.location.origin,
                formName: curFormName,
                cmp: curCmp
            });
        } else if (request.action === "pageChanged") {
            chrome.runtime.sendMessage(
                {
                    farewell: window.location.origin,
                    formName: getformName(),
                    cmp: getCmp()
                },
                function (response) {
                    console.log("pagechanged:" + response);
                }
            );
        }

    }
);
//https://stackoverflow.com/questions/9899372/pure-javascript-equivalent-of-jquerys-ready-how-to-call-a-function-when-t
window.readyHandlers = [];
window.ready = function ready(handler) {
    window.readyHandlers.push(handler);
    handleState();
};

window.handleState = function handleState() {
    if (['interactive', 'complete'].indexOf(document.readyState) > -1) {
        while (window.readyHandlers.length > 0) {
            (window.readyHandlers.shift())();
        }
    }
};

document.onreadystatechange = window.handleState;

ready(function () {
    chrome.runtime.sendMessage(
        {
            farewell: window.location.origin,
            formName: getformName(),
            cmp: getCmp()
        },
        function (response) {
            console.log("d3f2 onreadystatechange: " + JSON.stringify(response));
        }
    );
});
