/// <reference path="chrome.intellisense.js" />

//per https://www.lullabot.com/articles/creating-a-simple-chrome-extension
function resetDefaultSuggestion() {
  chrome.omnibox.setDefaultSuggestion({ description: "Type a table name to search or ?? to detect tables from formname" });
}

resetDefaultSuggestion();

function navigate(url) {
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    chrome.tabs.update(tabs[0].id, { url: url });
  });
}

chrome.omnibox.onInputEntered.addListener(function (text) {

  chrome.storage.sync.get({
    defaultd365TableUrl: "https://usnconeboxax1aos.cloud.onebox.dynamics.com",
    defaultd365TableCmp: "usmf",
    inferUrl: true
  }, function (items) {
    console.log("d3f2:item " + JSON.stringify(items));
    if (items.inferUrl) {
      chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
        chrome.tabs.sendMessage(tabs[0].id, { action: "getCurrentUrl" }, function (response) {
          try {
            console.log("d3f2 bg rx from content: " + JSON.stringify(response));
            var cmpParm = response.cmp ? response.cmp : items.defaultd365TableCmp;

            var navToUrl = response.farewell + "/?mi=SysTableBrowser&TableName=" + text + "&cmp=" + cmpParm + "&limitednav=true&lng=en-us";
            navigate(navToUrl);
            console.log("d3f2:'inferUrl'" + navToUrl);
            console.log("d3f2:'response'" + JSON.stringify(response));
          }
          catch (error) {
            console.error(error);
          }
        });
      });

    }
    else {
      var navToUrl = Items.defaultd365TableUrl + "/?mi=SysTableBrowser&TableName=" + text + "&cmp=" + items.defaultd365TableCmp + "&limitednav=true&lng=en-us";
      navigate(navToUrl);
      console.log("d3f2:non-infer'url'" + navToUrl);

    }

  });

});

chrome.omnibox.onInputChanged.addListener((input, suggest) => {

  chrome.storage.sync.get({ d3f2formname: "" }, function (items) {
    if (items.d3f2formname != ""){
      suggest(getMatchingProperties({ form: items.d3f2formname, input: input, maxresults: 20 }));
      }
  });

});

chrome.omnibox.onInputStarted.addListener((input, suggest) => {
  var formnametmp = "";
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    chrome.tabs.sendMessage(tabs[0].id, { action: "getCurrentUrl" }, function (response) {
      try { formnametmp = response.formname; }
      catch (error) { console.log(error); }
      console.log(response);
    });
  });
  if (formnametmp != ""){
    suggest(getMatchingProperties({ form: formnametmp, input: input, maxresults: 20 }));
  }

});


//checks for axtables or forms that match depending on input
//returns a collection(max = args.maxresults) that can be fed directly to omnibox
//of [{description:"", content:""}]
function getMatchingProperties(args) {
  var input = args.input;
  var axformname = args.form;
  var list = [];
  var maxresults = args.maxresults;

  if (input.includes("  ")
    || input.includes("detect")
    || input.includes("?")) {
    list = axFormToAxTables.mappings.filter(item => {
      return item.formname == axformname
    });
  }

  var list2 = axTables.filter(item => item.table.toLowerCase().includes(input.toLowerCase()));
  if (list.length > 0) {
    list.push.apply(list, list2);
  }
  else {
    list = list2;
  }

  //todo:muliples?
  if (list.length > 0) {
    var result = [];
    for (var i = 0; i < (list.length < maxresults ? list.length : maxresults); i++) {
      console.log("d3f2 omnibox table result[" + i + "] added: " + list[i].table);
      result.push({
        description: list[i].formname ?
          "form: " + list[i].formname + " table: " + list[i].table
          : list[i].table + "<dim> " + list[i].developerdocumentation + "</dim>",
        content: list[i].table
      })
    }

    return result;
  }
  return [{ description: "no table found", content: "google.com" }];
}


function onclickedlistener(tab) {
  var formnametmp = "";
  chrome.tabs.query({ active: true, currentWindow: true }, function (tabs) {
    chrome.tabs.sendMessage(tabs[0].id, { action: "getCurrentUrl" }, function (response) {
      try { formnametmp = response.formname }
      catch (error) { console.log(error); }
      console.log("test 2 response json: " + JSON.stringify(response));
      if (response && response.formName) {
        chrome.tabs.create({ url: chrome.runtime.getURL("index.html?form=" + response.formName) });
      }
      else {
        chrome.tabs.create({ url: chrome.runtime.getURL("index.html") });
      }
    });
  });
}
chrome.browserAction.onClicked.addListener(onclickedlistener);

chrome.tabs.onUpdated.addListener(
  function (tabId, changeInfo, tab) {
    // read changeInfo data and do something with it
    // like send the new url to contentscripts.js
    if (changeInfo.url) {
      chrome.tabs.sendMessage(tabId, {
        action: 'pageChanged',
        url: changeInfo.url
      })
    }
  }
);



